// GoGOST -- Pure Go GOST cryptographic functions library
// Copyright (C) 2015-2016 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package gost3410

type DigestSize uint8

// Curve params: p, q, a, b, bx, by
type CurveParams [6][]byte

var (
	DigestSize2001 DigestSize = 32
	DigestSize2012 DigestSize = 64

	CurveParamsGostR34102001cc CurveParams = CurveParams([6][]byte{
		{0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC7},
		{0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
			0x60, 0x61, 0x17, 0xa2, 0xf4, 0xbd, 0xe4, 0x28,
			0xb7, 0x45, 0x8a, 0x54, 0xb6, 0xe8, 0x7b, 0x85},
		{0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc4},
		{0x2d, 0x06, 0xB4, 0x26, 0x5e, 0xbc, 0x74, 0x9f,
			0xf7, 0xd0, 0xf1, 0xf1, 0xf8, 0x82, 0x32, 0xe8,
			0x16, 0x32, 0xe9, 0x08, 0x8f, 0xd4, 0x4b, 0x77,
			0x87, 0xd5, 0xe4, 0x07, 0xe9, 0x55, 0x08, 0x0c},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02},
		{0xa2, 0x0e, 0x03, 0x4b, 0xf8, 0x81, 0x3e, 0xf5,
			0xc1, 0x8d, 0x01, 0x10, 0x5e, 0x72, 0x6a, 0x17,
			0xeb, 0x24, 0x8b, 0x26, 0x4a, 0xe9, 0x70, 0x6f,
			0x44, 0x0b, 0xed, 0xc8, 0xcc, 0xb6, 0xb2, 0x2c},
	})
	CurveParamsGostR34102001Test CurveParams = CurveParams([6][]byte{
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x31},
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
			0x50, 0xFE, 0x8A, 0x18, 0x92, 0x97, 0x61, 0x54,
			0xC5, 0x9C, 0xFC, 0x19, 0x3A, 0xCC, 0xF5, 0xB3},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07},
		{0x5F, 0xBF, 0xF4, 0x98, 0xAA, 0x93, 0x8C, 0xE7,
			0x39, 0xB8, 0xE0, 0x22, 0xFB, 0xAF, 0xEF, 0x40,
			0x56, 0x3F, 0x6E, 0x6A, 0x34, 0x72, 0xFC, 0x2A,
			0x51, 0x4C, 0x0C, 0xE9, 0xDA, 0xE2, 0x3B, 0x7E},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02},
		{0x08, 0xE2, 0xA8, 0xA0, 0xE6, 0x51, 0x47, 0xD4,
			0xBD, 0x63, 0x16, 0x03, 0x0E, 0x16, 0xD1, 0x9C,
			0x85, 0xC9, 0x7F, 0x0A, 0x9C, 0xA2, 0x67, 0x12,
			0x2B, 0x96, 0xAB, 0xBC, 0xEA, 0x7E, 0x8F, 0xC8},
	})
	CurveParamsGostR34102001CryptoProA CurveParams = CurveParams([6][]byte{
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x97},
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0x6C, 0x61, 0x10, 0x70, 0x99, 0x5A, 0xD1, 0x00,
			0x45, 0x84, 0x1B, 0x09, 0xB7, 0x61, 0xB8, 0x93},
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x94},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
		{0x8D, 0x91, 0xE4, 0x71, 0xE0, 0x98, 0x9C, 0xDA,
			0x27, 0xDF, 0x50, 0x5A, 0x45, 0x3F, 0x2B, 0x76,
			0x35, 0x29, 0x4F, 0x2D, 0xDF, 0x23, 0xE3, 0xB1,
			0x22, 0xAC, 0xC9, 0x9C, 0x9E, 0x9F, 0x1E, 0x14},
	})
	CurveParamsGostR34102001CryptoProB CurveParams = CurveParams([6][]byte{
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x99},
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
			0x5F, 0x70, 0x0C, 0xFF, 0xF1, 0xA6, 0x24, 0xE5,
			0xE4, 0x97, 0x16, 0x1B, 0xCC, 0x8A, 0x19, 0x8F},
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x96},
		{0x3E, 0x1A, 0xF4, 0x19, 0xA2, 0x69, 0xA5, 0xF8,
			0x66, 0xA7, 0xD3, 0xC2, 0x5C, 0x3D, 0xF8, 0x0A,
			0xE9, 0x79, 0x25, 0x93, 0x73, 0xFF, 0x2B, 0x18,
			0x2F, 0x49, 0xD4, 0xCE, 0x7E, 0x1B, 0xBC, 0x8B},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
		{0x3F, 0xA8, 0x12, 0x43, 0x59, 0xF9, 0x66, 0x80,
			0xB8, 0x3D, 0x1C, 0x3E, 0xB2, 0xC0, 0x70, 0xE5,
			0xC5, 0x45, 0xC9, 0x85, 0x8D, 0x03, 0xEC, 0xFB,
			0x74, 0x4B, 0xF8, 0xD7, 0x17, 0x71, 0x7E, 0xFC},
	})
	CurveParamsGostR34102001CryptoProC CurveParams = CurveParams([6][]byte{
		{0x9B, 0x9F, 0x60, 0x5F, 0x5A, 0x85, 0x81, 0x07,
			0xAB, 0x1E, 0xC8, 0x5E, 0x6B, 0x41, 0xC8, 0xAA,
			0xCF, 0x84, 0x6E, 0x86, 0x78, 0x90, 0x51, 0xD3,
			0x79, 0x98, 0xF7, 0xB9, 0x02, 0x2D, 0x75, 0x9B},
		{0x9B, 0x9F, 0x60, 0x5F, 0x5A, 0x85, 0x81, 0x07,
			0xAB, 0x1E, 0xC8, 0x5E, 0x6B, 0x41, 0xC8, 0xAA,
			0x58, 0x2C, 0xA3, 0x51, 0x1E, 0xDD, 0xFB, 0x74,
			0xF0, 0x2F, 0x3A, 0x65, 0x98, 0x98, 0x0B, 0xB9},
		{0x9B, 0x9F, 0x60, 0x5F, 0x5A, 0x85, 0x81, 0x07,
			0xAB, 0x1E, 0xC8, 0x5E, 0x6B, 0x41, 0xC8, 0xAA,
			0xCF, 0x84, 0x6E, 0x86, 0x78, 0x90, 0x51, 0xD3,
			0x79, 0x98, 0xF7, 0xB9, 0x02, 0x2D, 0x75, 0x98},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x5a},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x41, 0xEC, 0xE5, 0x57, 0x43, 0x71, 0x1A, 0x8C,
			0x3C, 0xBF, 0x37, 0x83, 0xCD, 0x08, 0xC0, 0xEE,
			0x4D, 0x4D, 0xC4, 0x40, 0xD4, 0x64, 0x1A, 0x8F,
			0x36, 0x6E, 0x55, 0x0D, 0xFD, 0xB3, 0xBB, 0x67},
	})
	CurveParamsGostR34102001CryptoProXchA CurveParams = CurveParams([6][]byte{
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x97},
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0x6C, 0x61, 0x10, 0x70, 0x99, 0x5A, 0xD1, 0x00,
			0x45, 0x84, 0x1B, 0x09, 0xB7, 0x61, 0xB8, 0x93},
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x94},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
		{0x8D, 0x91, 0xE4, 0x71, 0xE0, 0x98, 0x9C, 0xDA,
			0x27, 0xDF, 0x50, 0x5A, 0x45, 0x3F, 0x2B, 0x76,
			0x35, 0x29, 0x4F, 0x2D, 0xDF, 0x23, 0xE3, 0xB1,
			0x22, 0xAC, 0xC9, 0x9C, 0x9E, 0x9F, 0x1E, 0x14},
	})
	CurveParamsGostR34102001CryptoProXchB CurveParams = CurveParams([6][]byte{
		{0x9B, 0x9F, 0x60, 0x5F, 0x5A, 0x85, 0x81, 0x07,
			0xAB, 0x1E, 0xC8, 0x5E, 0x6B, 0x41, 0xC8, 0xAA,
			0xCF, 0x84, 0x6E, 0x86, 0x78, 0x90, 0x51, 0xD3,
			0x79, 0x98, 0xF7, 0xB9, 0x02, 0x2D, 0x75, 0x9B},
		{0x9B, 0x9F, 0x60, 0x5F, 0x5A, 0x85, 0x81, 0x07,
			0xAB, 0x1E, 0xC8, 0x5E, 0x6B, 0x41, 0xC8, 0xAA,
			0x58, 0x2C, 0xA3, 0x51, 0x1E, 0xDD, 0xFB, 0x74,
			0xF0, 0x2F, 0x3A, 0x65, 0x98, 0x98, 0x0B, 0xB9},
		{0x9B, 0x9F, 0x60, 0x5F, 0x5A, 0x85, 0x81, 0x07,
			0xAB, 0x1E, 0xC8, 0x5E, 0x6B, 0x41, 0xC8, 0xAA,
			0xCF, 0x84, 0x6E, 0x86, 0x78, 0x90, 0x51, 0xD3,
			0x79, 0x98, 0xF7, 0xB9, 0x02, 0x2D, 0x75, 0x98},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x5a},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x41, 0xEC, 0xE5, 0x57, 0x43, 0x71, 0x1A, 0x8C,
			0x3C, 0xBF, 0x37, 0x83, 0xCD, 0x08, 0xC0, 0xEE,
			0x4D, 0x4D, 0xC4, 0x40, 0xD4, 0x64, 0x1A, 0x8F,
			0x36, 0x6E, 0x55, 0x0D, 0xFD, 0xB3, 0xBB, 0x67},
	})
	CurveParamsGostR34102012TC26ParamSetA CurveParams = CurveParams([6][]byte{
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFD, 0xC7},
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0x27, 0xE6, 0x95, 0x32, 0xF4, 0x8D, 0x89, 0x11,
			0x6F, 0xF2, 0x2B, 0x8D, 0x4E, 0x05, 0x60, 0x60, 0x9B, 0x4B,
			0x38, 0xAB, 0xFA, 0xD2, 0xB8, 0x5D, 0xCA, 0xCD, 0xB1, 0x41,
			0x1F, 0x10, 0xB2, 0x75},
		{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFD, 0xC4},
		{0xE8, 0xC2, 0x50, 0x5D, 0xED, 0xFC, 0x86, 0xDD, 0xC1, 0xBD,
			0x0B, 0x2B, 0x66, 0x67, 0xF1, 0xDA, 0x34, 0xB8, 0x25, 0x74,
			0x76, 0x1C, 0xB0, 0xE8, 0x79, 0xBD, 0x08, 0x1C, 0xFD, 0x0B,
			0x62, 0x65, 0xEE, 0x3C, 0xB0, 0x90, 0xF3, 0x0D, 0x27, 0x61,
			0x4C, 0xB4, 0x57, 0x40, 0x10, 0xDA, 0x90, 0xDD, 0x86, 0x2E,
			0xF9, 0xD4, 0xEB, 0xEE, 0x47, 0x61, 0x50, 0x31, 0x90, 0x78,
			0x5A, 0x71, 0xC7, 0x60},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x03},
		{0x75, 0x03, 0xCF, 0xE8, 0x7A, 0x83, 0x6A, 0xE3, 0xA6, 0x1B,
			0x88, 0x16, 0xE2, 0x54, 0x50, 0xE6, 0xCE, 0x5E, 0x1C, 0x93,
			0xAC, 0xF1, 0xAB, 0xC1, 0x77, 0x80, 0x64, 0xFD, 0xCB, 0xEF,
			0xA9, 0x21, 0xDF, 0x16, 0x26, 0xBE, 0x4F, 0xD0, 0x36, 0xE9,
			0x3D, 0x75, 0xE6, 0xA5, 0x0E, 0x3A, 0x41, 0xE9, 0x80, 0x28,
			0xFE, 0x5F, 0xC2, 0x35, 0xF5, 0xB8, 0x89, 0xA5, 0x89, 0xCB,
			0x52, 0x15, 0xF2, 0xA4},
	})
	CurveParamsGostR34102012TC26ParamSetB CurveParams = CurveParams([6][]byte{
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x6F},
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x01, 0x49, 0xA1, 0xEC, 0x14, 0x25, 0x65, 0xA5, 0x45,
			0xAC, 0xFD, 0xB7, 0x7B, 0xD9, 0xD4, 0x0C, 0xFA, 0x8B, 0x99,
			0x67, 0x12, 0x10, 0x1B, 0xEA, 0x0E, 0xC6, 0x34, 0x6C, 0x54,
			0x37, 0x4F, 0x25, 0xBD},
		{0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x6C},
		{0x68, 0x7D, 0x1B, 0x45, 0x9D, 0xC8, 0x41, 0x45, 0x7E, 0x3E,
			0x06, 0xCF, 0x6F, 0x5E, 0x25, 0x17, 0xB9, 0x7C, 0x7D, 0x61,
			0x4A, 0xF1, 0x38, 0xBC, 0xBF, 0x85, 0xDC, 0x80, 0x6C, 0x4B,
			0x28, 0x9F, 0x3E, 0x96, 0x5D, 0x2D, 0xB1, 0x41, 0x6D, 0x21,
			0x7F, 0x8B, 0x27, 0x6F, 0xAD, 0x1A, 0xB6, 0x9C, 0x50, 0xF7,
			0x8B, 0xEE, 0x1F, 0xA3, 0x10, 0x6E, 0xFB, 0x8C, 0xCB, 0xC7,
			0xC5, 0x14, 0x01, 0x16},
		{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x02},
		{0x1A, 0x8F, 0x7E, 0xDA, 0x38, 0x9B, 0x09, 0x4C, 0x2C, 0x07,
			0x1E, 0x36, 0x47, 0xA8, 0x94, 0x0F, 0x3C, 0x12, 0x3B, 0x69,
			0x75, 0x78, 0xC2, 0x13, 0xBE, 0x6D, 0xD9, 0xE6, 0xC8, 0xEC,
			0x73, 0x35, 0xDC, 0xB2, 0x28, 0xFD, 0x1E, 0xDF, 0x4A, 0x39,
			0x15, 0x2C, 0xBC, 0xAA, 0xF8, 0xC0, 0x39, 0x88, 0x28, 0x04,
			0x10, 0x55, 0xF9, 0x4C, 0xEE, 0xEC, 0x7E, 0x21, 0x34, 0x07,
			0x80, 0xFE, 0x41, 0xBD},
	})

	CurveParamsDefault = CurveParamsGostR34102001CryptoProA
)

func NewCurveFromParams(params CurveParams) (*Curve, error) {
	return NewCurve(
		params[0][:],
		params[1][:],
		params[2][:],
		params[3][:],
		params[4][:],
		params[5][:],
	)
}
